/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.valhelsia_structures;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stal111.valhelsia_structures.common.recipe.AxeCraftingRecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.resourcepack.recipe.IRecipeTemplate;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class AxeCraftingRecipeTemplate
implements IRecipeTemplate<AxeCraftingRecipeBuilder.Result> {
    public final Item output;
    public final int count;
    public final String group;
    public final Ingredient input;
    private List<ICondition> conditions = new ArrayList<ICondition>();

    public AxeCraftingRecipeTemplate(JsonObject json) {
        JsonObject output = json.get("output").getAsJsonObject();
        ResourceLocation item = new ResourceLocation(output.get("item").getAsString());
        int count = 1;
        JsonElement c = output.get("count");
        if (c != null) {
            count = c.getAsInt();
        }
        this.count = count;
        this.output = (Item)Registry.f_122827_.m_7745_(item);
        JsonElement g = json.get("group");
        this.group = g == null ? "" : g.getAsString();
        this.input = Ingredient.m_43917_((JsonElement)json.get("input"));
    }

    public <T extends BlockType> AxeCraftingRecipeBuilder.Result createSimilar(T originalMat, T destinationMat, Item unlockItem, @Nullable String id) {
        ItemLike newOutput = BlockType.changeItemBlockType((ItemLike)this.output, originalMat, destinationMat);
        if (newOutput == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s", this.output));
        }
        boolean atLeastOneChanged = false;
        Ingredient newInput = this.input;
        for (ItemStack in : newInput.m_43908_()) {
            ItemLike i;
            Item it = in.m_41720_();
            if (it == Items.f_42127_ || (i = BlockType.changeItemBlockType((ItemLike)it, originalMat, destinationMat)) == null) continue;
            atLeastOneChanged = true;
            newInput = Ingredient.m_43929_((ItemLike[])new ItemLike[]{i});
            break;
        }
        if (!atLeastOneChanged) {
            return null;
        }
        AxeCraftingRecipeBuilder builder = new AxeCraftingRecipeBuilder(newInput, newOutput.m_5456_(), this.count);
        builder.unlocks("has_log", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{unlockItem}));
        AtomicReference newRecipe = new AtomicReference();
        if (id == null) {
            builder.save(r -> newRecipe.set((AxeCraftingRecipeBuilder.Result)r));
        } else {
            builder.save(r -> newRecipe.set((AxeCraftingRecipeBuilder.Result)r), id);
        }
        return (AxeCraftingRecipeBuilder.Result)newRecipe.get();
    }

    public List<ICondition> getConditions() {
        return this.conditions;
    }

    public void addCondition(ICondition condition) {
        this.conditions.add(condition);
    }
}

